#include <iostream>
#include <stack>
#include <vector>
#include <algorithm>
using namespace std;

int main()
{
    long long n;
    cin >> n;

    vector<pair<long long,long long>> v(n);
    vector<long long> ind(n);    

    for(long long i = 0; i < n; i++){
        cin >> v[i].first;
        ind[i] = i;
    }
    for(long long i = 0; i < n; i++){
        cin >> v[i].second;
    }

    vector<long long> order(n);
    for(long long i=0;i<n;i++) order[i]=i;

    sort(order.begin(), order.end(), [&](long long a, long long b){
        return v[a].first < v[b].first;
    });      
    
    vector<pair<long long,long long>> sv(n);
    for(long long i=0;i<n;i++) sv[i] = v[order[i]];

    vector<long long> NGR(n);
    vector<long long> NGL(n);

    stack<long long> st;
    st.push(0);
    NGL[0] = -1;

    for(long long i=1; i<n; i++){
        while(!st.empty() && sv[st.top()].second <= sv[i].second)
            st.pop();
        if(st.empty()) NGL[i] = -1;
        else NGL[i] = st.top();
        st.push(i);
    }

    while(!st.empty()) st.pop();
    st.push(n-1);
    NGR[n-1] = -1;

    for(long long i=n-2; i>=0; i--){
        while(!st.empty() && sv[st.top()].second <= sv[i].second)
            st.pop();
        if(st.empty()) NGR[i] = -1;
        else NGR[i] = st.top();
        st.push(i);
    }

    vector<long long> res(n);
    for(long long i=0;i<n;i++){
        long long d = 100000000, l = 100000000;

        if(NGR[i] != -1)
            d = (sv[NGR[i]].first - sv[NGR[i]].second + sv[i].second) - sv[i].first;

        if(NGL[i] != -1)
            l = sv[i].first - (sv[NGL[i]].first + sv[NGL[i]].second - sv[i].second);

        res[i] = min(d, l);
    }
    
    vector<long long> final_res(n, -1);
    for(long long i=0;i<n;i++){
        long long orig = order[i];
        if(res[i] >= 100000000) final_res[orig] = -1;
        else final_res[orig] = res[i];
    }
    for(long long i=0;i<n;i++){
        cout << final_res[i] <<endl;
    }
}